/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWLogonDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    private static final String m_className = "VWLogonDialog";
    Logger logger = Logger.getLogger("filenet.pe.peorb.client.token");
    private int m_closeStatus = 1;
    private VWSession m_vwSession = null;
    private VWSessionInfo m_vwSessionInfo = null;
    private String[] m_routerNames = null;
    private String[] m_routerPorts = null;
    private JTextField m_userName = null;
    private JPasswordField m_password = null;
    private JLabel m_hostName = null;
    private JComboBox m_routerURLs = null;
    private JButton m_logonButton = null;
    private JButton m_cancelButton = null;
    private JButton m_advancedButton = null;
    private JButton m_helpButton = null;
    private String m_securityGroupName = null;
    private String m_routerPath = null;
    private String m_dialogTitle = "Logon";

    public VWLogonDialog(Frame parentFrame, VWSessionInfo sessionInfo) {
        this(parentFrame, sessionInfo, sessionInfo.getProperty("hostName"), sessionInfo.getRouterNames(), sessionInfo.getRouterPorts());
    }

    public VWLogonDialog(Frame parentFrame, VWSessionInfo sessionInfo, String hostName, String[] routerNames, String[] routerPorts) {
        super(parentFrame);
        try {
            this.m_vwSessionInfo = sessionInfo;
            this.m_hostName = new JLabel(hostName);
            if (routerNames != null && routerNames.length > 0) {
                this.m_routerNames = new String[routerNames.length];
                System.arraycopy(routerNames, 0, this.m_routerNames, 0, routerNames.length);
            }
            if (routerPorts != null && routerPorts.length > 0) {
                this.m_routerPorts = new String[routerPorts.length];
                System.arraycopy(routerPorts, 0, this.m_routerPorts, 0, routerPorts.length);
            }
            if (routerNames != null && routerNames.length > 0) {
                String routerName = null;
                String routerPort = null;
                Vector<String> routers = new Vector<String>();
                for (int nIndex = 0; nIndex < routerNames.length; ++nIndex) {
                    routerName = routerNames[nIndex].trim();
                    if (routerName == null || routerName.length() == 0) continue;
                    if (routerPorts != null && routerPorts.length > nIndex && (routerPort = routerPorts[nIndex].trim()) != null && routerPort.length() != 0) {
                        routerName = routerName.concat(":");
                        routerName = routerName.concat(routerPort);
                    }
                    routers.addElement(routerName);
                }
                this.m_routerURLs = new JComboBox(routers);
            }
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getCloseStatus() {
        return this.m_closeStatus;
    }

    public String getSelectedRouterPath() {
        return this.m_routerPath;
    }

    public VWSession getVWSession() {
        return this.m_vwSession;
    }

    public boolean isLogonOK(String[] securityGroupNames, boolean bSessionManagement, boolean bIsDevelopmentMode) {
        try {
            if (bSessionManagement) {
                this.m_vwSession = VWIDMBaseFactory.instance().getSavedVWSession();
            }
            if (this.m_vwSession == null) {
                if (this.m_routerURLs == null || this.m_routerURLs != null && this.m_routerURLs.getModel().getSize() == 0) {
                    JOptionPane.showMessageDialog(this, VWResource.s_noConfiguredRouters, this.m_dialogTitle, 0);
                    return false;
                }
                String selectedRouter = (String)this.m_routerURLs.getSelectedItem();
                String portNumber = this.getPortNumber(selectedRouter);
                String routerName = this.getRouterName(selectedRouter);
                this.m_vwSession = VWIDMBaseFactory.instance().getVWSession(this.m_hostName.getText(), portNumber, routerName);
            }
            if (this.m_vwSession == null) {
                this.m_vwSession = VWIDMBaseFactory.instance().getVWSessionFromLDAP((Frame)this.getParent(), this.m_hostName.getText(), this.m_routerNames, this.m_routerPorts);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_vwSession == null && bIsDevelopmentMode) {
            try {
                String[] routerNames;
                String name = this.m_vwSessionInfo.getProperty("name");
                String password = this.m_vwSessionInfo.getProperty("pw");
                if (name != null && password != null && (routerNames = this.m_vwSessionInfo.getRouterNames()) != null && routerNames.length >= 1) {
                    this.m_vwSession = new VWSession(name, password, routerNames[0]);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.m_vwSession != null) {
            VWDefaultSessionProxy.setSession(this.m_vwSession);
            if (this.validateUser(securityGroupNames, bIsDevelopmentMode)) {
                return true;
            }
            VWDefaultSessionProxy.removeSession(this.m_vwSession);
            this.m_vwSession = null;
            if (this.m_vwSessionInfo.isWorkPlaceWebApp()) {
                return false;
            }
        }
        this.setVisible(true);
        if (this.m_vwSession != null && bSessionManagement) {
            try {
                VWIDMBaseFactory.instance().setVWSessionToken(this.m_userName.getText(), new String(this.m_password.getPassword()), "", this.m_vwSession.getToken(), this.m_routerPath);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return this.m_vwSession != null;
    }

    public boolean logonWithToken(String token) {
        block5: {
            try {
                if (this.m_vwSession != null || this.m_vwSessionInfo.isWorkPlaceWebApp()) break block5;
                if (this.m_routerURLs == null || this.m_routerURLs != null && this.m_routerURLs.getModel().getSize() == 0) {
                    return false;
                }
                this.m_routerPath = this.getRouterPath();
                this.m_vwSession = new VWSession();
                this.m_vwSession.logonWithToken(token, this.m_routerPath);
                try {
                    VWIDMBaseFactory.instance().setVWSessionToken("", "", "", this.m_vwSession.getToken(), this.m_routerPath);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
                return true;
            }
            catch (Exception ex) {
                this.m_vwSession = null;
            }
        }
        return false;
    }

    public boolean validateUser(String[] securityGroupNames, boolean bIsDevelopmentMode) {
        boolean bIsOK = true;
        try {
            boolean bIsWorkplace = this.m_vwSessionInfo.isWorkPlaceWebApp();
            if (securityGroupNames != null && securityGroupNames.length > 0 && !this.isValidLogonUser(securityGroupNames, bIsWorkplace, bIsDevelopmentMode)) {
                this.m_securityGroupName = null;
                bIsOK = false;
                StringBuffer buffer = new StringBuffer(VWResource.s_logonGroupsRequirement + "\n");
                for (int nIndex = 0; nIndex < securityGroupNames.length; ++nIndex) {
                    if (nIndex > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(securityGroupNames[nIndex]);
                }
                if (!bIsWorkplace) {
                    buffer.append("\n" + VWResource.s_sysAdminGGroup);
                }
                JOptionPane.showMessageDialog(this, buffer.toString(), this.m_dialogTitle, 0);
            }
            if (this.m_vwSession != null) {
                this.m_vwSessionInfo.updateDefaultWebApplication(this.m_vwSession);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bIsOK;
    }

    public String getSecurityGroupName() {
        return this.m_securityGroupName;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_logonButton) {
            this.onLogonButton(event);
        } else if (object == this.m_cancelButton) {
            this.onCancelButton(event);
        } else if (object == this.m_advancedButton) {
            this.onAdvancedButton(event);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwd053.htm");
        } else {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setLogonButtonState();
    }

    public void removeUpdate(DocumentEvent event) {
        this.setLogonButtonState();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void init() {
        try {
            Dimension dim = VWStringUtils.stringToDimension("425,135");
            if (dim == null) {
                dim = new Dimension(385, 120);
            }
            this.setSize(dim);
            try {
                this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(2).toString();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.setTitle(this.m_dialogTitle);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getUserInfoPanel(), "Center");
            boolean bShowAdvancedButton = this.m_routerURLs != null && this.m_routerURLs.getModel().getSize() > 1;
            this.getContentPane().add((Component)this.getButtonControlPanel(bShowAdvancedButton), "Last");
            this.setLogonButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getUserInfoPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        JLabel label = null;
        int nRow = 0;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(10, 10, 10, 10);
            label = new JLabel(VWResource.s_userName);
            if (this.m_userName == null) {
                this.m_userName = new JTextField();
            }
            this.m_userName.getDocument().addDocumentListener(this);
            this.addRowControls(label, this.m_userName, ++nRow, panel, gbCons);
            label = new JLabel(VWResource.s_password);
            if (this.m_password == null) {
                this.m_password = new JPasswordField();
            }
            this.addRowControls(label, this.m_password, ++nRow, panel, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getAdvancedPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        JLabel label = null;
        int nRow = 0;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(10, 10, 10, 10);
            label = new JLabel(VWResource.s_userName);
            this.addRowControls(label, this.m_userName, nRow, panel, gbCons);
            label = new JLabel(VWResource.s_password);
            this.addRowControls(label, this.m_password, ++nRow, panel, gbCons);
            label = new JLabel(VWResource.s_hostName);
            if (this.m_hostName == null) {
                this.m_hostName = new JLabel();
            }
            this.addRowControls(label, this.m_hostName, ++nRow, panel, gbCons);
            label = new JLabel(VWResource.s_routerName);
            if (this.m_routerURLs == null) {
                this.m_routerURLs = new JComboBox();
            }
            this.addRowControls(label, this.m_routerURLs, ++nRow, panel, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void addRowControls(Component comp1, Component comp2, int nRow, JPanel panel, GridBagConstraints gbCons) {
        try {
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = nRow;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add(comp1, gbCons);
            gbCons.gridwidth = 3;
            gbCons.gridx = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            panel.add(comp2, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getButtonControlPanel(boolean bShowAdvanced) {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            if (this.m_logonButton == null) {
                this.m_logonButton = new JButton(VWResource.s_logon);
                this.m_logonButton.setSelected(true);
                this.m_logonButton.addActionListener(this);
            }
            panel.add(this.m_logonButton);
            if (this.m_cancelButton == null) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_cancelButton.addActionListener(this);
            }
            panel.add(this.m_cancelButton);
            if (bShowAdvanced) {
                if (this.m_advancedButton == null) {
                    this.m_advancedButton = new JButton(VWResource.s_advanced);
                    this.m_advancedButton.addActionListener(this);
                }
                panel.add(this.m_advancedButton);
            }
            if (this.m_helpButton == null) {
                this.m_helpButton = new JButton(VWResource.s_help);
                this.m_helpButton.addActionListener(this);
            }
            panel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_logonButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private boolean isValidLogonUser(String[] groupNames, boolean bIsWorkplace, boolean bIsDevelopmentMode) {
        try {
            if (this.m_vwSession == null) {
                return false;
            }
            if (bIsDevelopmentMode && groupNames.length > 0) {
                this.m_securityGroupName = groupNames[0];
                return true;
            }
            String domainName = VWDefaultSessionProxy.getDefaultSecurityDomainName();
            for (int nIndex = 0; nIndex < groupNames.length; ++nIndex) {
                this.m_securityGroupName = groupNames[nIndex];
                VWParticipant group = VWDefaultSessionProxy.fetchGroup(domainName, groupNames[nIndex]);
                if (group != null) {
                    if (this.m_vwSession.isMemberOfGroup(groupNames[nIndex])) {
                        return true;
                    }
                    if (!bIsWorkplace) {
                        if (this.m_vwSession.isMemberOfGroup(VWResource.s_sysAdminGGroup)) {
                            return true;
                        }
                        if (nIndex == groupNames.length - 1) {
                            return false;
                        }
                    }
                }
                if (!bIsWorkplace || this.m_vwSessionInfo == null) continue;
                String[] systemRoles = this.m_vwSessionInfo.getSystemRoles();
                if (systemRoles != null && systemRoles.length > 0) {
                    for (int i = 0; i < systemRoles.length; ++i) {
                        if (systemRoles[i] == null || VWStringUtils.compareIgnoreCase(systemRoles[i], groupNames[nIndex]) != 0) continue;
                        return true;
                    }
                }
                if (nIndex != groupNames.length - 1) continue;
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private String getRouterPath() {
        String m_method = "getRouterPath";
        String selectedRouter = (String)this.m_routerURLs.getSelectedItem();
        String routerName = this.getRouterName(selectedRouter);
        String aeProxyServer = this.m_vwSessionInfo.getProperty("AEProxyBaseURL");
        if (this.logger.isFinest()) {
            this.logger.finest(m_className, "getRouterPath", "routerName=" + routerName + ", aePRoxyServer = " + aeProxyServer);
        }
        if (aeProxyServer != null) {
            if (!aeProxyServer.endsWith("/")) {
                aeProxyServer = aeProxyServer + "/";
            }
            return aeProxyServer + "vwsoaprouter" + "?" + routerName;
        }
        return routerName;
    }

    private void onLogonButton(ActionEvent event) {
        try {
            String password = new String(this.m_password.getPassword());
            this.m_routerPath = this.getRouterPath();
            if (this.m_vwSession == null) {
                this.m_vwSession = new VWSession();
            }
            if (this.logger.isFinest()) {
                this.logger.finest(m_className, "onLogonButton", this.m_userName.getText() + "," + this.m_routerPath);
            }
            this.m_vwSession.logon(this.m_userName.getText(), password, this.m_routerPath);
            VWDefaultSessionProxy.setSession(this.m_vwSession);
            String[] groupNames = null;
            if (this.m_securityGroupName != null) {
                groupNames = new String[]{this.m_securityGroupName};
            }
            if (!this.validateUser(groupNames, false)) {
                VWDefaultSessionProxy.removeSession(this.m_vwSession);
                this.m_vwSession.logoff();
                this.m_vwSession = null;
                return;
            }
            this.m_closeStatus = 0;
            this.setVisible(false);
        }
        catch (Exception ex) {
            this.m_vwSession = null;
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), this.m_dialogTitle, 0);
        }
    }

    private void onCancelButton(ActionEvent event) {
        try {
            this.m_closeStatus = 1;
            this.m_vwSession = null;
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAdvancedButton(ActionEvent event) {
        try {
            this.getContentPane().removeAll();
            Dimension dim = VWStringUtils.stringToDimension("425,285");
            if (dim == null) {
                dim = new Dimension(385, 260);
            }
            this.setSize(dim);
            this.getContentPane().add((Component)this.getAdvancedPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonControlPanel(false), "Last");
            this.setLogonButtonState();
            this.invalidate();
            this.validate();
            this.repaint();
            this.m_userName.requestFocus();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setLogonButtonState() {
        String tempString;
        if (this.m_logonButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_userName != null && (tempString = this.m_userName.getText()) != null && (tempString = tempString.trim()).length() > 0) {
            bEnable = true;
        }
        if (this.m_logonButton.isEnabled() != bEnable) {
            this.m_logonButton.setEnabled(bEnable);
        }
    }

    private String getPortNumber(String sourceStr) {
        String portNumber = null;
        try {
            int nIndex;
            if (sourceStr != null && sourceStr.length() != 0 && (nIndex = sourceStr.indexOf(":")) != -1) {
                portNumber = sourceStr.substring(nIndex + 1, sourceStr.length());
            }
            if (portNumber == null) {
                portNumber = "32771";
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return portNumber;
    }

    private String getRouterName(String sourceStr) {
        String routerName = null;
        try {
            if (sourceStr != null && sourceStr.length() != 0) {
                int nIndex = sourceStr.indexOf(":");
                routerName = nIndex != -1 ? sourceStr.substring(0, nIndex) : sourceStr;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return routerName;
    }
}

